// Letter2.java
// 11 feb Jonas
import java.applet.*;
import java.awt.*;
import Globals; 

public class Letter2 {
  ShowMobileIPCanvas canvas;
  public int lastX, lastY;
  private final int length = 20, height = 12;
  public String info; // Letter information text
  LetterDialog letterDialog;
  private boolean contensDialogExist = false;
 
  public Letter2(ShowMobileIPCanvas father) {
    this.canvas=father;
  }
  
  public void drawLetter(Graphics g, int x, int y) {
    lastX = x; lastY =y;
    g.setColor(Color.white);
    g.fillRect(lastX, lastY, length, height);
    g.setColor(Color.blue);
    g.drawRect(lastX, lastY, length, height);
    g.drawLine(lastX, lastY, lastX+length, lastY+height);
    g.drawLine(lastX, lastY+height, lastX+length, lastY);
  }
  
  public void eraseLetter(Graphics g) {
    g.setColor(Color.lightGray);
    g.fillRect(lastX-1, lastY-1, length + 2, height + 2);
    canvas.paint(g);
  }
  // Checks whether coordinate. is inside the Letter
  public boolean posInLetter() {
    int x = Globals.last_x; int y = Globals.last_y;
    return((x >= lastX) && (x <= lastX + length) 
	&& (y >= lastY) && (y <=lastY + height));
  }
  // Show a Dialog with information about Letter
  public void letterDialog() {
    if (! contensDialogExist) {
      contensDialogExist = true;
      letterDialog = new LetterDialog(canvas.frame, info);
    }
    else {
      letterDialog.setVisible(false);
      letterDialog.show();
    }
  }
 
  public void closeLetterDialog() {
    if (contensDialogExist) {
      contensDialogExist = false;
      letterDialog.dispose();
      letterDialog = null; 
    }
  }
}
